/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWConfigStatusRender
extends DefaultTableCellRenderer {
    public static final int TYPE_FIELD = 0;
    public static final int TYPE_INDEX = 1;
    private static final ImageIcon ICON_DATAFIELD = VWImageLoader.createImageIcon("field.gif");
    private static final ImageIcon ICON_SYS = VWImageLoader.createImageIcon("system.gif");
    private static final ImageIcon ICON_MANDATORY = VWImageLoader.createImageIcon("mandatory.gif");
    private static final ImageIcon ICON_MODIFIED = VWImageLoader.createImageIcon("modified.gif");
    private static final ImageIcon ICON_NEW = VWImageLoader.createImageIcon("new.gif");
    private int m_nType;

    public VWConfigStatusRender(int nType) {
        this.m_nType = nType;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value instanceof Integer) {
                String toolTip = new String();
                JLabel aLabel = (JLabel)component;
                aLabel.setIcon(null);
                aLabel.setText("");
                if (this.m_nType == 1) {
                    if (this.isSystemStatus((Integer)value)) {
                        aLabel.setIcon(ICON_SYS);
                        toolTip = this.isMandatorySystemStatus((Integer)value) ? VWResource.SystemMandatoryIndex : (this.isNewStatus((Integer)value) ? VWResource.SystemIndexNew : (this.isModifiedStatus((Integer)value) ? VWResource.SystemIndexModified : VWResource.SystemIndex));
                    } else {
                        aLabel.setIcon(ICON_DATAFIELD);
                        toolTip = this.isNewStatus((Integer)value) ? VWResource.UserDefinedIndexNew : (this.isModifiedStatus((Integer)value) ? VWResource.UserDefinedIndexModified : VWResource.UserDefinedIndex);
                    }
                } else if (this.isSystemStatus((Integer)value)) {
                    if (this.isMandatoryStatus((Integer)value)) {
                        aLabel.setIcon(ICON_MANDATORY);
                        toolTip = this.isNewStatus((Integer)value) ? VWResource.SystemMandatoryFieldNew : (this.isModifiedStatus((Integer)value) ? VWResource.SystemMandatoryFieldModified : VWResource.SystemMandatoryField);
                    } else {
                        toolTip = this.isNewStatus((Integer)value) ? VWResource.SystemFieldNew : (this.isModifiedStatus((Integer)value) ? VWResource.SystemFieldModified : VWResource.SystemField);
                    }
                } else {
                    aLabel.setIcon(ICON_DATAFIELD);
                    toolTip = this.isNewStatus((Integer)value) ? VWResource.DataFieldNew : (this.isModifiedStatus((Integer)value) ? VWResource.DataFieldModified : VWResource.DataField);
                }
                aLabel.setToolTipText(toolTip);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }

    private boolean isSystemStatus(Integer status) {
        return (status & 2) == 2;
    }

    private boolean isMandatorySystemStatus(Integer status) {
        int iMandatorySys = 6;
        return (status & iMandatorySys) == iMandatorySys;
    }

    private boolean isMandatoryStatus(Integer status) {
        return (status & 4) == 4;
    }

    private boolean isModifiedStatus(Integer status) {
        return (status & 0x10) == 16;
    }

    private boolean isNewStatus(Integer status) {
        return (status & 0x20) == 32;
    }
}

